#ifndef _DEFINE_H_
#define _DEFINE_H_

#define AF901X_SILICON_TUNER 0x02
#define AF901X_CAN_TUNER 0x01
		
#define     AF901X_API_VER_0          0
#define     AF901X_API_VER_1          1
#define     AF901X_API_VER_2          7
#define     AF901X_API_VER_3          6

//**********************************************************************
// Define MPEG TS mode
//**********************************************************************
#define		AF901X_OUTPUT_MPEG_PARALLEL	        0x00
#define		AF901X_OUTPUT_MPEG_SERIAL	        0x01
#define		AF901X_OUTPUT_USB_OUTPUT	        0x02

//**********************************************************************
// Define FW related position
//**********************************************************************
#define     MERC_FW_DOWNLOAD_PARAM_BASE 0x50FC
#define     MERC_FW_DOWNLOAD_BASE       0x5100
#define     MERC_FW_STATUS              0x98BE // For Mercury Load FW
#define     MERC_ADDR_FW_VER            0x5103
#define     MERC_EEPROM_I2C_ADDR        0x9A50
#define     MERC_IR_TABLE_BASE_ADDR     0x9A56
#define     MERC_BOOT_REQUEST           0xE205
#define     MERC_ADDR_HW_VER            0x116B
/****************************************************************************
 * Mercury Code
 ****************************************************************************/
#define     USB_CMD_GET_CURR_CONFIG       0x10
#define     USB_CMD_FW_DOWNLOAD           0x11
#define     USB_CMD_CHECKSUM              0x12
#define     USB_CMD_BOOT                  0x13
#define     USB_CMD_MEM_READ              0x20
#define     USB_CMD_MEM_WRITE             0x21
#define     USB_CMD_EEPROM_READ           0x22
#define     USB_CMD_EEPROM_WRITE          0x22
#define     USB_CMD_GENERAL_I2C           0x22
#define     USB_CMD_COPY_FW               0x23
#define     USB_CMD_GET_USBFW_VERSION     0x24
#define     USB_CMD_RE_DOWNLOAD_FW        0x25
#define     USB_CMD_VIRTUAL_MEM_WRITE     0x26
#define     USB_CMD_RE_LINK               0x5A  


#define EEPROM_FLB_OFS  8
#define EEPROM_IRMODE      (EEPROM_FLB_OFS+0x10)   //00:disabled, 01:HID
#define EEPROM_SELSUSPEND  (EEPROM_FLB_OFS+0x28)   //Selective Suspend Mode
#define EEPROM_TSMODE      (EEPROM_FLB_OFS+0x28+1) //0:one ts, 1:dual ts
#define EEPROM_2WIREADDR   (EEPROM_FLB_OFS+0x28+2) //MPEG2 2WireAddr
#define EEPROM_SUSPEND     (EEPROM_FLB_OFS+0x28+3) //Suspend Mode
#define EEPROM_IRTYPE      (EEPROM_FLB_OFS+0x28+4) //0:NEC, 1:RC6
#define EEPROM_SAWBW1      (EEPROM_FLB_OFS+0x28+5)
#define EEPROM_XTAL1       (EEPROM_FLB_OFS+0x28+6) //0:28800, 1:20480
#define EEPROM_SPECINV1    (EEPROM_FLB_OFS+0x28+7)
#define EEPROM_TUNERID     (EEPROM_FLB_OFS+0x30+4) 
#define EEPROM_IFFREQL     (EEPROM_FLB_OFS+0x30) 
#define EEPROM_IFFREQH     (EEPROM_FLB_OFS+0x30+1)   
#define EEPROM_IF1L        (EEPROM_FLB_OFS+0x30+2)   
#define EEPROM_IF1H        (EEPROM_FLB_OFS+0x30+3)
#define EEPROM_SHIFT       (0x10)                 //EEPROM Addr Shift for slave front end
#define SLAVE_DEMOD_2WIREADDR 0x3A


#define REG_MASK(pos, len, mask)                (mask[len-1] << pos)
#define REG_CLEAR(temp, pos, len, mask)         (temp & (~REG_MASK(pos, len, mask)))
#define REG_CREATE(val, temp, pos, len, mask)   ((val << pos) | (REG_CLEAR(temp, pos, len, mask)))
#define REG_GET(value, pos, len, mask)          ((value & REG_MASK(pos, len, mask)) >> pos)

#define AF901X_REG_RESET                    0xAEFF
#define AF901X_REG_TRIGGER_OFSM             0xFFFF
#define AF901X_REG_2WIRE_CMD_STATUS         0xC913

//**********************************************************************
// Enums/Structures for demod functions
//**********************************************************************
typedef enum
{
    BW6M = 0,
    BW7M,
    BW8M
} BW;

typedef enum
{
    QPSKs = 0,
    QAM_16s,
    QAM_64s
} MOD_TYPE;

typedef enum
{
    FFT_2K = 0,
    FFT_8K
} MyFFT;

typedef enum
{
    OVER32 = 0,     // 1/32
    OVER16,         // 1/16
    OVER8,          // 1/8
    OVER4,          // 1/4
} GI;

typedef enum
{
    HPLP_HP = 0,
    HPLP_LP
} HPLP;             // High Priority or Low Priority

typedef enum
{
    CR_1over2 = 0,  // 1/2
    CR_2over3,      // 2/3
    CR_3over4,      // 3/4
    CR_5over6,      // 5/6
    CR_7over8,      // 7/8
    CR_none,        // none, NXT doesn't have this one
} CR;               // Code Rate

typedef enum
{
    HIER_NONE = 0,
    HIER_ALPHA_1,
    HIER_ALPHA_2,
    HIER_ALPHA_4,
} TPS_HIER;         // TPS Hierarchy and Alpha value

typedef enum
{
    AGC_NORMAL = 0,
    AGC_INVERSE
} AGC_POLARITY;     // TPS Hierarchy and Alpha value

typedef enum
{
    I2C_QUIESCENT = 0,
    I2C_BYPASS
} I2C_MODE;

typedef enum
{
    TS_7_48 = 0,
    TS_1_8,
    TS_7_64,
} TS;

typedef struct
{
    u32     freq;
    MOD_TYPE    mod;
    MyFFT       fft;
    GI          gi;
    HPLP        hplp;
    CR          hpcr;
    CR          lpcr;
    TPS_HIER    TpsHier;
    BW          bw;
} SYS_INFO,  *PSYS_INFO;

#endif
